 USE [population];

/* running this script will reset all data and return the model to year zero with a starter population of ten people and no genetic load. */

/* first, the tables all need to be truncated. */
TRUNCATE TABLE person;
TRUNCATE TABLE mutation;
TRUNCATE TABLE married_pair;
TRUNCATE TABLE married_pair_mutation;
TRUNCATE TABLE staging_person;
TRUNCATE TABLE staging_married_pair;
TRUNCATE TABLE staging_done_married_pair;
TRUNCATE TABLE staging_dead_person;
TRUNCATE TABLE staging_bride;
TRUNCATE TABLE staging_groom;
TRUNCATE TABLE statistics_table;
TRUNCATE TABLE death_table;
TRUNCATE TABLE genome;
TRUNCATE TABLE parental_age_mutations;



/* A bunch of people with no mutations are created in the beginning. 
   Since they don't have any mutations yet, it's recommended to let these people evolve over a few tens of thousands of years under "natural" settings before 
   running a model that implements any overpopulation policies. 
   Once their population size and mutational load has reached a natural equilibrium, the model can be continued under other settings. */
INSERT INTO staging_person (parents_id)
VALUES                     (0);

INSERT INTO staging_person (parents_id)
VALUES                     (-1);

INSERT INTO staging_person (parents_id)
VALUES                     (-2);

INSERT INTO staging_person (parents_id)
VALUES                     (-3);

INSERT INTO staging_person (parents_id)
VALUES                     (-4);

INSERT INTO staging_person (parents_id)
VALUES                     (-5);

INSERT INTO staging_person (parents_id)
VALUES                     (-6);

INSERT INTO staging_person (parents_id)
VALUES                     (-7);

INSERT INTO staging_person (parents_id)
VALUES                     (-8);

INSERT INTO staging_person (parents_id)
VALUES                     (-9);

INSERT INTO person (person_id, parents_id, sex,         year_of_birth, surv_pen, mutation_count, inheritor, lineage_id, 
                    line_gen,  attr_pen,   success_pen, inher_pen)
SELECT              person_id, parents_id, person_id%2, -18,           0,        0,              0,         0,
                    0,         0,          0,           0
FROM   staging_person;

/* the statistics table needs to be populated with some starter data so it doesn't throw an error when it is referenced in the first loop of the model */
INSERT INTO statistics_table (births, deaths, current_year, current_pop)
SELECT                        0,      0,      -2,           (SELECT Count(*)
                                                             FROM   person)

/* clear staging_data from the first people */
DELETE FROM staging_person

/* insert data into the actuarial table. */
INSERT INTO death_table (age, death_rate)
VALUES                  (2,   50)

INSERT INTO death_table (age, death_rate)
VALUES                  (4,   20)

INSERT INTO death_table (age, death_rate)
VALUES                  (6,   10)

INSERT INTO death_table (age, death_rate)
VALUES                  (8,   5)

INSERT INTO death_table (age, death_rate)
VALUES                  (10,  3)

INSERT INTO death_table (age, death_rate)
VALUES                  (12,  2)

INSERT INTO death_table (age, death_rate)
VALUES                  (14,  1)

INSERT INTO death_table (age, death_rate)
VALUES                  (16,  1)

/*for adults, "Death" should not be taken literally. Could also be infertility, economic failure, etc. */
INSERT INTO death_table (age, death_rate)
VALUES                  (18,  30) 

INSERT INTO death_table (age, death_rate)
VALUES                  (20,  20)

INSERT INTO death_table (age, death_rate)
VALUES                  (22,  10)

INSERT INTO death_table (age, death_rate)
VALUES                  (24,  10)

INSERT INTO death_table (age, death_rate)
VALUES                  (26,  10)

INSERT INTO death_table (age, death_rate)
VALUES                  (28,  10)

INSERT INTO death_table (age, death_rate)
VALUES                  (30,  10)

INSERT INTO death_table (age, death_rate)
VALUES                  (32,  15)

INSERT INTO death_table (age, death_rate)
VALUES                  (34,  15)

INSERT INTO death_table (age, death_rate)
VALUES                  (36,  60)

INSERT INTO death_table (age, death_rate)
VALUES                  (38,  100)

INSERT INTO death_table (age, death_rate)
VALUES                  (40,  150)

INSERT INTO death_table (age, death_rate)
VALUES                  (42,  250)

INSERT INTO death_table (age, death_rate)
VALUES                  (44,  500)

INSERT INTO death_table (age, death_rate)
VALUES                  (46,  1000)

INSERT INTO death_table (age, death_rate)
VALUES                  (48,  2000)

INSERT INTO death_table (age, death_rate)
VALUES                  (50,  0) 
/* NOTE: people automatically fall out of the model at age 50. */

/* this table records how much the mutation rate increaes with age. */
INSERT INTO parental_age_mutations (age, sex, increased_mutation_rate)
VALUES                             (30,  0,   0.1)

INSERT INTO parental_age_mutations (age, sex, increased_mutation_rate)
VALUES                             (32,  0,   0.2)

INSERT INTO parental_age_mutations (age, sex, increased_mutation_rate)
VALUES                             (34,  0,   0.3)

INSERT INTO parental_age_mutations (age, sex, increased_mutation_rate)
VALUES                             (36,  0,   0.4)

INSERT INTO parental_age_mutations (age, sex, increased_mutation_rate)
VALUES                             (38,  0,   0.5)

INSERT INTO parental_age_mutations (age, sex, increased_mutation_rate)
VALUES                             (40,  0,   0.6)

INSERT INTO parental_age_mutations (age, sex, increased_mutation_rate)
VALUES                             (42,  0,   0.7)

INSERT INTO parental_age_mutations (age, sex, increased_mutation_rate)
VALUES                             (44,  0,   0.9)

INSERT INTO parental_age_mutations (age, sex, increased_mutation_rate)
VALUES                             (46,  0,   1.0)

INSERT INTO parental_age_mutations (age, sex, increased_mutation_rate)
VALUES                             (48,  0,   1.1)

INSERT INTO parental_age_mutations (age, sex, increased_mutation_rate)
VALUES                             (30,  1,   0.1)

INSERT INTO parental_age_mutations (age, sex, increased_mutation_rate)
VALUES                             (32,  1,   0.2)

INSERT INTO parental_age_mutations (age, sex, increased_mutation_rate)
VALUES                             (34,  1,   0.3)

INSERT INTO parental_age_mutations (age, sex, increased_mutation_rate)
VALUES                             (36,  1,   0.4)

INSERT INTO parental_age_mutations (age, sex, increased_mutation_rate)
VALUES                             (38,  1,   0.5)

INSERT INTO parental_age_mutations (age, sex, increased_mutation_rate)
VALUES                             (40,  1,   0.6)

INSERT INTO parental_age_mutations (age, sex, increased_mutation_rate)
VALUES                             (42,  1,   0.7)

INSERT INTO parental_age_mutations (age, sex, increased_mutation_rate)
VALUES                             (44,  1,   0.9)

INSERT INTO parental_age_mutations (age, sex, increased_mutation_rate)
VALUES                             (46,  1,  1.0)

INSERT INTO parental_age_mutations (age, sex, increased_mutation_rate)
VALUES                             (48,  1,   1.1)  